/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iDate vec4(0.0,0.0,0.0,iGlobalTime)

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

vec2 rotate(in vec2 p, in float t)
{
   return p * cos(-t) + vec2(p.y, -p.x) * sin(-t);
}

float shapeRad1(in vec3 p)
{
    float a = atan(p.z, p.x);
    return 0.5 * ((sin(5.0 * a)) + 3.0);
}

float shapeRad2(in vec3 p)
{
    float a = atan(p.z, p.x);
    return abs(sin(2.0 * a)) + 1.0;
}

float deQuad(in vec2 p, in float h)
{
     return max(abs(p.x), abs(p.y)) - h;
}

float deTri(in vec2 p, in float h)
{
     return abs(p.x) + abs(p.y) - h;
}

float deCircle(in vec2 p, in float r)
{
     return length(p) - r;
}

float deShape(in vec2 p)
{
    
    return max(max(deTri(p, 1.0), -p.y*p.y+p.x-0.7), -p.x*p.x+ abs(p.y)-0.6);
}

float shape1(in vec3 p, vec2 q)  {return          deQuad(q, 1.0);}
float shape2(in vec3 p, vec2 q)  {return 0.35 *    deTri(q, 1.0);}
float shape3(in vec3 p, vec2 q)  {return        deCircle(q, 1.0);}
float shape4(in vec3 p, vec2 q)  {return 0.35 *  deShape(q);}
float shape5(in vec3 p, vec2 q)  {return 0.35 *   deQuad(q * vec2(shapeRad1(p), 1.0), 1.0);}
float shape6(in vec3 p, vec2 q)  {return 0.35 *    deTri(q * vec2(shapeRad1(p), 1.0), 1.0);}
float shape7(in vec3 p, vec2 q)  {return 0.35 * deCircle(q * vec2(shapeRad1(p), 1.0), 1.0);}
float shape8(in vec3 p, vec2 q)  {return 0.35 *  deShape(q * vec2(shapeRad1(p), 1.0));}
float shape9(in vec3 p, vec2 q)  {return 0.35 *   deQuad(q * vec2(shapeRad2(p), 1.0), 1.0);}
float shape10(in vec3 p, vec2 q) {return 0.35 *    deTri(q * vec2(shapeRad2(p), 1.0), 1.0);}
float shape11(in vec3 p, vec2 q) {return 0.35 * deCircle(q * vec2(shapeRad2(p), 1.0), 1.0);}
float shape12(in vec3 p, vec2 q) {return 0.35 *  deShape(q * vec2(shapeRad2(p), 1.0));}

float map(in vec3 p)
{    
   vec2 q = vec2(length(p.xz), p.y);
    float t = mod(iGlobalTime * 0.8, 36.0);
    if (t < 3.0)  return mix( shape1(p, q),  shape2(p, q), smoothstep( 1.0,  2.0, t));
    if (t < 6.0)  return mix( shape2(p, q),  shape3(p, q), smoothstep( 4.0,  5.0, t));
    if (t < 9.0)  return mix( shape3(p, q),  shape4(p, q), smoothstep( 7.0,  8.0, t));
    if (t < 12.0) return mix( shape4(p, q),  shape5(p, q), smoothstep(10.0, 11.0, t));
    if (t < 15.0) return mix( shape5(p, q),  shape6(p, q), smoothstep(13.0, 14.0, t));
    if (t < 18.0) return mix( shape6(p, q),  shape7(p, q), smoothstep(16.0, 17.0, t));
    if (t < 21.0) return mix( shape7(p, q),  shape8(p, q), smoothstep(19.0, 20.0, t));
    if (t < 24.0) return mix( shape8(p, q),  shape9(p, q), smoothstep(22.0, 23.0, t));
   if (t < 27.0) return mix( shape9(p, q), shape10(p, q), smoothstep(25.0, 26.0, t));    
   if (t < 30.0) return mix(shape10(p, q), shape11(p, q), smoothstep(28.0, 29.0, t));    
   if (t < 33.0) return mix(shape11(p, q), shape12(p, q), smoothstep(31.0, 32.0, t));    
              return mix(shape12(p, q),  shape1(p, q), smoothstep(34.0, 35.0, t));    
}

vec3 calcNormal(in vec3 p)
{
   const vec2 e = vec2(0.0001, 0.0);
   return normalize(vec3(
      map(p + e.xyy) - map(p - e.xyy),
      map(p + e.yxy) - map(p - e.yxy),
      map(p + e.yyx) - map(p - e.yyx)));
}

float march(in vec3 ro, in vec3 rd)
{
   const float maxd = 50.0;
   const float precis = 0.001;
    float h = precis * 2.0;
    float t = 0.0;
   float res = -1.0;
    for(int i = 0; i < 64; i++)
    {
        if(h < precis || t > maxd) break;
       h = map(ro + rd * t);
        t += h;
    }
    if(t < maxd) res = t;
    return res;
}

vec3 transform(in vec3 p)
{
    p.yz = rotate(p.yz, iGlobalTime * 0.5);
    p.zx = rotate(p.zx, iGlobalTime * 0.7);
    return p;
}

void main(void)
{
   vec2 p = (2.0 * gl_FragCoord.xy - iResolution.xy) / iResolution.y;
   vec3 col = vec3(0.0);
   vec3 rd = normalize(vec3(p, -1.8));
   vec3 ro = vec3(0.0, 0.0, 3.0);
   vec3 li = normalize(vec3(0.5, 0.8, 3.0));
   ro = transform(ro);
   rd = transform(rd);
   li = transform(li);
    float t = march(ro, rd);
    if(t > -0.001)
    {
      vec3 pos = ro + t * rd;
      vec3 n = calcNormal(pos);
      float dif = clamp((dot(n, li) + 0.5) * 0.7, 0.3, 1.0);
      float dep = exp(-0.005 * pos.z * pos.z);
      col = texture2D(iChannel0, pos.xz).rgb * dif * dep;
      col = pow(col, vec3(0.8));
   }
      gl_FragColor = vec4(col, length(col)*100.0);
}
